/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.grid.handler;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.autocrafting.engine.ICraftingTaskError;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.CraftingPreviewElementError;
import com.raoulvdberge.refinedstorage.network.MessageGridCraftingPreviewResponse;
import com.raoulvdberge.refinedstorage.network.MessageGridCraftingStartResponse;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;

public class FluidGridHandler
implements IFluidGridHandler {
    private final INetwork network;

    public FluidGridHandler(INetwork network) {
        this.network = network;
    }

    @Override
    public void onExtract(EntityPlayerMP player, UUID id, boolean shift) {
        FluidStack entry = this.network.getFluidStorageCache().getList().get((FluidStack)id);
        if (entry == null || entry.getCount() < 1000L || !this.network.getSecurityManager().hasPermission(Permission.EXTRACT, (EntityPlayer)player)) {
            return;
        }
        if (StackUtils.hasFluidBucket((FluidStack)entry.getStack())) {
            ItemStack bucket = null;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack slot = player.field_71071_by.func_70301_a(i);
                if (!API.instance().getComparer().isEqualNoQuantity(StackUtils.EMPTY_BUCKET, slot)) continue;
                bucket = StackUtils.EMPTY_BUCKET.func_77946_l();
                player.field_71071_by.func_70298_a(i, 1);
                break;
            }
            if (bucket == null) {
                bucket = this.network.extractItem(StackUtils.EMPTY_BUCKET, 1, Action.PERFORM);
            }
            if (!bucket.func_190926_b()) {
                IFluidHandlerItem fluidHandler = (IFluidHandlerItem)bucket.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                this.network.getFluidStorageTracker().changed((EntityPlayer)player, ((FluidStack)entry.getStack()).copy());
                StackListResult<FluidStack> extracted = this.network.extractFluid((FluidStack)entry.getStack(), 1000L, Action.PERFORM);
                if (extracted != null) {
                    fluidHandler.fill(extracted.getFixedStack(), true);
                }
                if (shift) {
                    if (!player.field_71071_by.func_70441_a(fluidHandler.getContainer().func_77946_l())) {
                        InventoryHelper.func_180173_a((World)player.func_130014_f_(), (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (ItemStack)fluidHandler.getContainer());
                    }
                } else {
                    player.field_71071_by.func_70437_b(fluidHandler.getContainer());
                    player.func_71113_k();
                }
                this.network.getNetworkItemHandler().drainEnergy((EntityPlayer)player, RS.INSTANCE.config.wirelessFluidGridExtractUsage);
            }
        }
    }

    @Override
    @Nullable
    public ItemStack onInsert(EntityPlayerMP player, ItemStack container) {
        if (!this.network.getSecurityManager().hasPermission(Permission.INSERT, (EntityPlayer)player)) {
            return container;
        }
        Pair<ItemStack, FluidStack> result = StackUtils.getFluid(container, true);
        if (result.getValue() != null && this.network.insertFluid((FluidStack)result.getValue(), ((FluidStack)result.getValue()).amount, Action.SIMULATE) == null) {
            this.network.getFluidStorageTracker().changed((EntityPlayer)player, ((FluidStack)result.getValue()).copy());
            result = StackUtils.getFluid(container, false);
            this.network.insertFluid((FluidStack)result.getValue(), ((FluidStack)result.getValue()).amount, Action.PERFORM);
            this.network.getNetworkItemHandler().drainEnergy((EntityPlayer)player, RS.INSTANCE.config.wirelessFluidGridInsertUsage);
            return (ItemStack)result.getLeft();
        }
        return container;
    }

    @Override
    public void onInsertHeldContainer(EntityPlayerMP player) {
        player.field_71071_by.func_70437_b(StackUtils.nullToEmpty(this.onInsert(player, player.field_71071_by.func_70445_o())));
        player.func_71113_k();
    }

    @Override
    public ItemStack onShiftClick(EntityPlayerMP player, ItemStack container) {
        return StackUtils.nullToEmpty(this.onInsert(player, container));
    }

    @Override
    public void onCraftingPreviewRequested(EntityPlayerMP player, UUID id, int quantity, boolean noPreview) {
        if (!this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (EntityPlayer)player)) {
            return;
        }
        FluidStack stack = this.network.getFluidStorageCache().getCraftablesList().get((FluidStack)id);
        if (stack != null) {
            ICraftingTask task = this.network.getCraftingManager().create((FluidStack)stack.getStack(), (long)quantity);
            if (task == null) {
                return;
            }
            CompletableFuture.supplyAsync(() -> {
                ICraftingTaskError error = task.calculate();
                FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> {
                    if (error == null && !task.hasMissing()) {
                        this.network.getCraftingManager().add(task);
                    }
                });
                if (error != null) {
                    RS.INSTANCE.network.sendTo((IMessage)new MessageGridCraftingPreviewResponse(Collections.singletonList(new CraftingPreviewElementError()), task.getId(), task.getCalculationTime(), quantity, true), player);
                } else if (noPreview && !task.hasMissing()) {
                    task.setCanUpdate(true);
                    RS.INSTANCE.network.sendTo((IMessage)new MessageGridCraftingStartResponse(), player);
                } else {
                    RS.INSTANCE.network.sendTo((IMessage)new MessageGridCraftingPreviewResponse(task.getPreviewStacks(), task.getId(), task.getCalculationTime(), quantity, true), player);
                }
                return null;
            }).exceptionally(t -> {
                t.printStackTrace();
                task.onCancelled();
                return null;
            });
        }
    }

    @Override
    public void onCraftingStartRequested(EntityPlayerMP player, UUID id, int quantity) {
        if (quantity <= 0 || !this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (EntityPlayer)player)) {
            return;
        }
        ICraftingTask task = this.network.getCraftingManager().getTask(id);
        if (task != null) {
            task.setCanUpdate(true);
        }
    }
}

